/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.UnmodifiableCollection;
import com.floragunn.fluent.collections.UnmodifiableSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface UnmodifiableMap<K, V>
extends Map<K, V> {
    public static <K, V> UnmodifiableMap<K, V> of(final Map<K, V> map) {
        if (map instanceof UnmodifiableMap) {
            return (UnmodifiableMap)map;
        }
        return new UnmodifiableMap<K, V>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return map.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return map.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return map.get(key);
            }

            @Override
            public UnmodifiableSet<K> keySet() {
                return UnmodifiableSet.of(map.keySet());
            }

            @Override
            public UnmodifiableCollection<V> values() {
                return UnmodifiableCollection.of(map.values());
            }

            @Override
            public UnmodifiableSet<Map.Entry<K, V>> entrySet() {
                return UnmodifiableSet.of(map.entrySet());
            }
        };
    }

    @Override
    public UnmodifiableSet<K> keySet();

    @Override
    public UnmodifiableSet<Map.Entry<K, V>> entrySet();

    @Override
    public UnmodifiableCollection<V> values();

    @Override
    @Deprecated
    default public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }
}

